﻿#include  "StdAfx.h"
#include  "NewArchiveUI.hpp"
#include  "NewArchiveDialog.hpp"
#include  "ProcessUI.hpp"
#include  "Main.hpp"
#include  <szRuntimeException.hpp>
#include  <szArchiveUpdater.hpp>
#include  <szPath.hpp>
#include  <boost/algorithm/string.hpp>

using namespace szpp;

NewArchiveUI::NewArchiveUI(ProcessUI *pUI) : pUI(pUI)
{
}

NewArchiveUI::~NewArchiveUI()
{
}

LRESULT ShowDialogFunc(void * ptr)
{
  CNewArchiveDialog *dlg = (CNewArchiveDialog *)ptr;
  if (0 != dlg->Create(hMainWnd))
  {
    dlg->ShowWindow(SW_SHOWDEFAULT);
    return true;
  }
  return false;
}

bool NewArchiveUI::Show(szstring *archivePath, ArchiveUpdaterOptions *options)
{
  // UpdateUI や DDV を使うためにモードレスで表示するので join してから変数にアクセス
  CNewArchiveDialog dialog(archivePath->c_str());
  if (!pUI->Invoke(ShowDialogFunc, &dialog))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot create dialog")));
  dialog.Join();

  bool ok = dialog.IsOK();
  if (ok)
  {
    options->ArchiveType = dialog.GetArchiveType();
    options->Method = dialog.GetMethod();
    options->Solid = dialog.GetSolid();
    options->Level = dialog.GetLevel();
    options->Password = dialog.GetPassword();
    options->EncryptionMethod = dialog.GetEncryptionMethod();
    options->Sfx = dialog.GetSfx();
    options->EncryptNames = dialog.GetEncryptNames();

    archivePath->assign(dialog.GetArchivePath());
    if (options->Sfx)
      archivePath->assign(ChangeExtension(*archivePath, SZL("exe")));
    if (options->ArchiveType == SZL("Tar"))
    {
      const szstring ext(boost::algorithm::to_lower_copy(ExtractExtension(*archivePath)));
      if (ext != SZL("tar"))
        archivePath->assign(ChangeExtension(*archivePath, SZL("tar")));
    }
  }

  return ok;
}
